//+------------------------------------------------------------------+
//|                                                 SSA of price.mq4 |
//|                                                           mladen |
//| forex-tsd elite section only                                     |
//+------------------------------------------------------------------+
#property copyright "mladen"
#property link      "mladenfx@gmail.com"

//
//
//    max arraySize - 5000
//    max lag - 200 (but will be slow for big lags)
//    max numberOfComputations - 20 (it just makes it "fit" more precise to source array)
//
//

#import "libSSA.dll"
   void fastSingular(double& sourceArray[],int arraySize, int lag, int numberOfComputationLoops, double& destinationArray[]);
#import

//
//
//
//
//

#property indicator_chart_window
#property indicator_buffers 3
#property indicator_color1  DeepSkyBlue
#property indicator_color2  PaleVioletRed
#property indicator_color3  PaleVioletRed
#property indicator_width1  2
#property indicator_width2  2
#property indicator_width3  2

//
//
//
//
//

extern int  Lag                  =   25;
extern int  NumberOfComputations =    2;
extern int  NumberOfBars         = 2000;
extern int  Price                = PRICE_CLOSE;
extern bool MultiColor           = true;
extern bool alertsOn             = false;
extern bool alertsOnCurrent      = true;
extern bool alertsMessage        = true;
extern bool alertsSound          = false;
extern bool alertsEmail          = false;

//
//
//
//
//

double SSA[];
double SSADa[];
double SSADb[];
double trend[];
double sourceValues[];
double calcValues[];

//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
//
//
//
//
//

int init()
{
   IndicatorBuffers(4);
   SetIndexBuffer(0,SSA);
   SetIndexBuffer(1,SSADa);
   SetIndexBuffer(2,SSADb);
   SetIndexBuffer(3,trend);
      NumberOfBars = MathMin(NumberOfBars,5000);
   ArrayResize(sourceValues,NumberOfBars);
   ArrayResize(calcValues,NumberOfBars);
   return(0);
}
int deinit() { return(0); }

//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
//
//
//
//
//

int start()
{
   static datetime barTime;
   int counted_bars=IndicatorCounted();
   int i,n,limit;

   //
   //
   //
   //
   //
      
   n = NumberOfBars;
      if (n > Bars)
      {
         n = Bars;
         if (ArraySize(sourceValues) != n) { ArrayResize(sourceValues,n); ArrayResize(calcValues,n); }
      }                     
      if(counted_bars < 0) return(-1);
      if(counted_bars > 0) counted_bars--;
           limit = MathMin(MathMax(Bars-counted_bars,Lag),n-1);
                   SetIndexDrawBegin(0,Bars-n);
                   if (barTime!=Time[0])
                   {
                        barTime=Time[0];
                        limit=n-1;
                   }                        

   //
   //
   //
   //
   //

   for(i=limit; i>=0; i--)  sourceValues[i]=iMA(NULL,0,1,0,MODE_SMA,Price,i);
                            fastSingular(sourceValues,n,Lag,NumberOfComputations,calcValues); ArrayCopy(SSA,calcValues);
   if (MultiColor && trend[limit]==-1) CleanPoint(limit,SSADa,SSADb);
   for(i=limit; i>=0; i--)  
   {
      SSADa[i] = EMPTY_VALUE;
      SSADb[i] = EMPTY_VALUE;
      trend[i] = trend[i+1];
         if (SSA[i]>SSA[i+1]) trend[i] =  1;
         if (SSA[i]<SSA[i+1]) trend[i] = -1;
         if (MultiColor && trend[i]==-1) PlotPoint(i,SSADa,SSADb,SSA);
   }
   
   //
   //
   //
   //
   //
   
   manageAlerts();   
   return(0);
}

//+-------------------------------------------------------------------
//|                                                                  
//+-------------------------------------------------------------------
//
//
//
//
//

void manageAlerts()
{
   if (alertsOn)
   {
      if (alertsOnCurrent)
           int whichBar = 0;
      else     whichBar = 1;
      for (;whichBar<Lag; whichBar++)
         if (trend[whichBar] != trend[whichBar+1])
         {
            if (trend[whichBar] ==  1) doAlert(whichBar,"up");
            if (trend[whichBar] == -1) doAlert(whichBar,"down");
            break;
         }
   }
}

//
//
//
//
//

void doAlert(int forBar, string doWhat)
{
   static string   previousAlert="nothing";
   static datetime previousTime;
   string message;
   
   if (previousAlert != doWhat || previousTime != Time[forBar]) {
       previousAlert  = doWhat;
       previousTime   = Time[forBar];

       //
       //
       //
       //
       //

       message =  StringConcatenate(Symbol()," at ",TimeToStr(TimeLocal(),TIME_SECONDS)," SSA at bar ",TimeToStr(previousTime,TIME_SECONDS)," changed to ",doWhat);
          if (alertsMessage) Alert(message);
          if (alertsEmail)   SendMail(StringConcatenate(Symbol()," SSA of price"),message);
          if (alertsSound)   PlaySound("alert2.wav");
   }
}

//+-------------------------------------------------------------------
//|                                                                  
//+-------------------------------------------------------------------
//
//
//
//
//

void CleanPoint(int i,double& first[],double& second[])
{
   if ((second[i]  != EMPTY_VALUE) && (second[i+1] != EMPTY_VALUE))
        second[i+1] = EMPTY_VALUE;
   else
      if ((first[i] != EMPTY_VALUE) && (first[i+1] != EMPTY_VALUE) && (first[i+2] == EMPTY_VALUE))
          first[i+1] = EMPTY_VALUE;
}

//
//
//
//
//

void PlotPoint(int i,double& first[],double& second[],double& from[])
{
   if (first[i+1] == EMPTY_VALUE)
      {
         if (first[i+2] == EMPTY_VALUE) {
                first[i]   = from[i];
                first[i+1] = from[i+1];
                second[i]  = EMPTY_VALUE;
            }
         else {
                second[i]   =  from[i];
                second[i+1] =  from[i+1];
                first[i]    = EMPTY_VALUE;
            }
      }
   else
      {
         first[i]  = from[i];
         second[i] = EMPTY_VALUE;
      }
}